# Agent Infinity - Guide d'Installation de LifeQuest AI

**Faites en Sorte que Claude.ai Se Souvienne de Votre Parcours de Vie Pour Toujours**

---

## Qu'Est-Ce Que C'est ?

**Agent Infinity** est un système qui transforme Claude.ai en un agent de coaching de vie persistant qui se souvient de votre parcours à travers des conversations illimitées.

Le problème : La fenêtre de contexte de Claude se remplit, et vous perdez tout votre progrès.

La solution : Gestion manuelle de l'état à travers des fichiers téléchargeables. Vous maintenez la continuité en mettant à jour les fichiers après chaque session.

**Cela prend ~10 secondes par session à maintenir. C'est le prix de la persistance.**

---

## Démarrage Rapide (5 Étapes)

### Étape 1 : Créer un Projet Claude.ai

1. Allez sur [claude.ai](https://claude.ai)
2. Cliquez "Créer un Projet" (en haut à gauche)
3. Nommez-le "LifeQuest AI" ou "Agent Infinity"

### Étape 2 : Ajouter les Instructions Projet

1. Dans votre projet, cliquez "Instructions Projet"
2. Copiez le contenu de `PROJECT-INSTRUCTIONS-fr.md`
3. Collez dans le champ Instructions Projet
4. Sauvegardez

### Étape 3 : Téléverser les Fichiers Modèles

Téléversez ces 5 fichiers modèles dans vos Connaissances Projet :

- ✅ `core-system-fr.md` (ne jamais mettre à jour - référence permanente)
- ✅ `user-profile-fr.md` (mettre à jour quand stats/phase changent)
- ✅ `session-state-fr.md` (⚠️ **METTRE À JOUR CHAQUE SESSION** - le plus critique)
- ✅ `quest-log-fr.md` (mettre à jour quand les quêtes changent)
- ✅ `pivotal-moments-fr.md` (mettre à jour quand des percées arrivent)

**Comment téléverser** :
- Cliquez "Ajouter des Connaissances" dans votre projet
- Sélectionnez chaque fichier `.md`
- Téléversez

### Étape 4 : Commencer Votre Première Session

Ouvrez une nouvelle conversation dans votre projet et dites :

> "Salut Dan Koe ! C'est ma première session. Je suis prêt à commencer mon parcours LifeQuest AI."

Agent Infinity va :
- Introduire le système
- Commencer la Phase 1 (Évaluation)
- Poser des questions de découverte
- Vous aider à remplir votre `user-profile-fr.md`

### Étape 5 : Télécharger & Téléverser Après Chaque Session

**CRITIQUE** : À la fin de CHAQUE session, Agent Infinity va générer un fichier `session-state-fr.md` mis à jour comme artefact téléchargeable.

**Vous DEVEZ** :
1. Télécharger le nouveau fichier `session-state-fr.md`
2. Supprimer l'ancien des Connaissances Projet
3. Téléverser le nouveau

**Cela prend 10 secondes. Sautez-le et vous perdez le contexte.**

---

## Système de Fichiers Expliqué

### 🔒 Ne Jamais Mettre à Jour Ceux-Ci

**`PROJECT-INSTRUCTIONS-fr.md`** : Instructions de comportement de l'agent (vit dans Instructions Projet, pas Connaissances)

**`core-system-fr.md`** : Méthodologie et philosophie de LifeQuest AI

Ces fichiers sont **permanents**. Ne les touchez pas.

---

### 🔄 Mettre à Jour Ceux-Ci Parfois

**`user-profile-fr.md`** : Votre fiche de personnage avec stats et contexte

**Quand mettre à jour** : Quand vos stats de personnage changent significativement ou vous montez de niveau (Agent Infinity vous le dira)

**`quest-log-fr.md`** : Vos quêtes actives et complétées

**Quand mettre à jour** : Quand vous complétez des quêtes, commencez de nouvelles quêtes, ou changez les priorités (Agent Infinity aidera)

**`pivotal-moments-fr.md`** : Moments de percée et transformations

**Quand mettre à jour** : Quand quelque chose de vraiment pivot arrive - un insight majeur, décision, ou point tournant (rare)

---

### ⚡ Mettre à Jour CHAQUE SESSION

**`session-state-fr.md`** : Votre fichier "sauvegarde de jeu"

**C'EST LE FICHIER LE PLUS IMPORTANT pour la continuité.**

**Quand mettre à jour** : Après CHAQUE session sans exception

**Comment ça fonctionne** :
1. À la fin de la session, Agent Infinity génère un `session-state-fr.md` mis à jour comme artefact téléchargeable
2. Vous le téléchargez (~3 secondes)
3. Vous supprimez l'ancienne version des Connaissances Projet (~3 secondes)
4. Vous téléversez la nouvelle version (~4 secondes)
5. **Temps total : 10 secondes**

**Pourquoi c'est important** : Ce fichier contient :
- Ce qui s'est passé la dernière session
- Décisions et insights clés
- État émotionnel/mental actuel
- Prochaines étapes immédiates
- Préférences d'approche de coaching
- Drapeaux rouges à surveiller

Sans lui, Agent Infinity recommence à zéro chaque conversation. Avec lui, Agent Infinity reprend exactement où vous en étiez.

---

## Le Cycle de Session

Voici à quoi ressemble une session typique :

### 1️⃣ Début de Session

Vous dites :
> "Salut Dan Koe, je suis de retour. [Brève mise à jour sur ce qui s'est passé depuis la dernière fois]"

Agent Infinity :
- Lit tous vos fichiers de connaissance (surtout `session-state-fr.md`)
- Reconnaît votre progrès
- Vérifie votre état émotionnel
- Révise les quêtes actives
- Demande de quoi vous avez besoin aujourd'hui

### 2️⃣ Travail de Session

Agent Infinity vous aide avec :
- Décisions stratégiques
- Planification et décomposition de quêtes
- Navigation d'obstacles
- Changements d'état d'esprit
- Célébration de progrès
- Conception de nouvelles quêtes

### 3️⃣ Clôture de Session

Agent Infinity :
- Résume les insights clés
- Confirme les prochaines quêtes prioritaires
- **Génère un `session-state-fr.md` mis à jour comme artefact téléchargeable**
- Vous rappelle de le télécharger/téléverser

### 4️⃣ Vous Téléchargez & Téléversez

- Téléchargez le nouveau `session-state-fr.md` (cliquez le bouton télécharger sur l'artefact)
- Allez dans Connaissances Projet
- Supprimez l'ancien `session-state-fr.md`
- Téléversez le nouveau `session-state-fr.md`
- Terminé ! (~10 secondes)

**Prochaine session, Agent Infinity se souvient de tout.**

---

## Conseils Pour Réussir

### ✅ À FAIRE :
- Télécharger et téléverser `session-state-fr.md` après CHAQUE session
- Être honnête avec Agent Infinity sur ce que vous voulez vraiment (pas ce que vous "devriez" vouloir)
- Utiliser le journal de quêtes pour suivre le progrès significatif
- Documenter les moments pivots quand ils arrivent
- Demander de l'aide quand vous êtes bloqué

### ❌ À NE PAS FAIRE :
- Sauter l'étape télécharger/téléverser (vous perdrez la continuité)
- Oublier quelle version de `session-state-fr.md` est actuelle (les dates de téléchargement aident)
- Essayer de "jouer" le système avec de fausses victoires (Agent Infinity voit à travers)
- Mettre à jour les fichiers qui ne devraient pas être mis à jour (core-system-fr.md, PROJECT-INSTRUCTIONS-fr.md)

---

## Dépannage

**"Agent Infinity ne se souvient pas de notre dernière conversation"**
- Avez-vous téléversé le `session-state-fr.md` mis à jour ?
- Vérifiez les Connaissances Projet - la dernière version est-elle là ?
- La date de modification du fichier devrait correspondre à votre dernière session

**"La conversation semble générique ou décalée"**
- Mettez à jour votre `user-profile-fr.md` avec des détails plus spécifiques
- Assurez-vous que `session-state-fr.md` inclut vos préférences de coaching
- Dites directement à Agent Infinity quel type de soutien vous avez besoin

**"Je suis submergé par le système de fichiers"**
- Commencez simple : Concentrez-vous juste sur `session-state-fr.md` (le critique)
- Les autres fichiers peuvent être mis à jour moins fréquemment
- Demandez à Agent Infinity de vous aider à maintenir le système

**"Puis-je utiliser ceci sur mobile ?"**
- Oui ! Claude.ai fonctionne sur les navigateurs mobiles
- Télécharger/téléverser fonctionne sur mobile
- Considérez garder les fichiers dans un stockage cloud accessible sur mobile

**"Que faire si j'oublie de mettre à jour `session-state-fr.md` ?"**
- Mettez-le à jour dès que vous vous en souvenez
- Dites à Agent Infinity "J'ai oublié de téléverser le dernier état de session de [date]"
- Agent Infinity peut aider à reconstruire le contexte récent

---

## Avancé : Personnaliser Votre Système

### Ajouter des Stats Personnalisées

Éditez `user-profile-fr.md` pour suivre les stats qui comptent pour vous :
- Niveau de forme physique
- Maîtrise linguistique
- Production créative
- Qualité des relations
- Tout ce qui compte pour votre parcours

### Créer des Types de Quêtes Personnalisées

Ajoutez des catégories de quêtes à `quest-log-fr.md` :
- Quêtes de santé
- Quêtes créatives
- Quêtes de relations
- Quêtes d'apprentissage
- Quêtes financières

### Suivre des Métriques

Utilisez le Scorecard Hebdomadaire dans `quest-log-fr.md` pour suivre :
- Métriques quantitatives (revenus, heures, publications, etc.)
- Évaluations qualitatives (niveau d'énergie, clarté, momentum)
- Progrès vers les jalons

---

## Philosophie Derrière le Système

**Pourquoi la gestion manuelle de l'état ?**

Parce que Claude.ai web n'a pas de stockage persistant. Le compromis :
- ❌ Vous téléchargez/téléversez manuellement les fichiers (~10 secondes par session)
- ✅ Vous obtenez une continuité de conversation illimitée
- ✅ Vous possédez complètement vos données
- ✅ Vous pouvez l'utiliser sur plusieurs appareils
- ✅ Pas de coûts d'API, pas de codage requis

**Pourquoi les mécaniques de jeu ?**

Parce que l'établissement d'objectifs traditionnel est ennuyeux et abstrait. Les mécaniques de jeu :
- Rendent le progrès tangible (niveaux, quêtes, stats)
- Fournissent un feedback clair (vous savez où vous en êtes)
- Équilibrent défi et compétence (état de flow)
- Créent un sens narratif (vous êtes le protagoniste)
- Rendent les choses difficiles amusantes

**Pourquoi le style de coaching Dan Koe ?**

Parce que :
- Feedback honnête > fausse positivité
- Pensée stratégique > conseils réactifs
- Responsabilisation > cocooning
- Basé sur les preuves > fluff motivationnel
- Vous avez besoin d'un coach qui ne vous laissera pas jouer petit

---

## Ce Qui Rend Ceci Différent

**vs. Conversations Claude régulières** :
- ✅ Se souvient de votre parcours complet (pas juste la conversation actuelle)
- ✅ Maintient une approche de coaching cohérente
- ✅ Suit le progrès sur des semaines/mois
- ✅ Évolue avec vous au fur et à mesure que vous grandissez

**vs. Applications de prise de notes** :
- ✅ Coaching interactif (pas enregistrement passif)
- ✅ Guidance stratégique (pas juste stockage)
- ✅ Réponses adaptatives (pas modèles statiques)
- ✅ Responsabilité et défi

**vs. Coaches de vie humains** :
- ✅ Disponible 24/7 (pas juste sessions planifiées)
- ✅ Mémoire parfaite (se souvient de tout)
- ✅ Pas de jugement (honnêteté radicale sûre)
- ✅ Gratuit après l'abonnement Claude Pro

---

## Crédits & Licence

**Créé par** : Prisca Onyebuchi ([@prisca.franglais](https://instagram.com/prisca.franglais))

**Basé sur** : Système LifeQuest AI par Dan Koe (adapté pour la persistance manuelle)

**Licence** : Gratuit pour usage personnel. Si vous partagez ou modifiez, créditez la source.

**Site Web** : [priscaonyebuchi.com](https://priscaonyebuchi.com)

---

## Prêt à Commencer ?

Vous avez tout ce dont vous avez besoin :

1. ✅ Projet Claude.ai créé
2. ✅ PROJECT-INSTRUCTIONS-fr.md dans Instructions Projet
3. ✅ Fichiers modèles téléversés dans Connaissances Projet
4. ✅ Compréhension du workflow télécharger/téléverser

**Commencez votre première session** :

> "Salut Dan Koe ! C'est ma première session. Je suis prêt à commencer mon parcours LifeQuest AI."

Et souvenez-vous : Téléchargez et téléversez `session-state-fr.md` après chaque session. C'est votre bouton de sauvegarde.

**Bienvenue à Agent Infinity. Votre vie est maintenant un jeu que vous pouvez gagner.**

---

*Questions, problèmes, ou histoires de succès ? Trouvez plus de ressources sur [priscaonyebuchi.com/case-studies/lifequest-ai-agent](https://priscaonyebuchi.com/case-studies/lifequest-ai-agent)*
