# Agent Infinity - LifeQuest AI Setup Guide

**Make Claude.ai Remember Your Life Journey Forever**

---

## What Is This?

**Agent Infinity** is a system that transforms Claude.ai into a persistent life coaching agent that remembers your journey across unlimited conversations.

The problem: Claude's context window fills up, and you lose all your progress.

The solution: Manual state management through downloadable files. You maintain continuity by updating files after each session.

**This takes ~10 seconds per session to maintain. That's the price of persistence.**

---

## Quick Start (5 Steps)

### Step 1: Create a Claude.ai Project

1. Go to [claude.ai](https://claude.ai)
2. Click "Create Project" (top left)
3. Name it "LifeQuest AI" or "Agent Infinity"

### Step 2: Add Project Instructions

1. In your project, click "Project Instructions"
2. Copy the contents of `PROJECT-INSTRUCTIONS.md`
3. Paste into the Project Instructions field
4. Save

### Step 3: Upload Template Files

Upload these 4 template files to your Project Knowledge:

- ✅ `core-system.md` (never update - permanent reference)
- ✅ `user-profile.md` (update when stats/phase change)
- ✅ `session-state.md` (⚠️ **UPDATE EVERY SESSION** - most critical)
- ✅ `quest-log.md` (update when quests change)
- ✅ `pivotal-moments.md` (update when breakthroughs happen)

**How to upload**:
- Click "Add Knowledge" in your project
- Select each `.md` file
- Upload

### Step 4: Start Your First Session

Open a new conversation in your project and say:

> "Hi Dan Koe! This is my first session. I'm ready to start my LifeQuest AI journey."

Agent Infinity will:
- Introduce the system
- Begin Phase 1 (Assessment)
- Ask discovery questions
- Help you fill in your `user-profile.md`

### Step 5: Download & Upload After Every Session

**CRITICAL**: At the end of EVERY session, Agent Infinity will generate an updated `session-state.md` file as a downloadable artifact.

**You MUST**:
1. Download the new `session-state.md` file
2. Delete the old one from Project Knowledge
3. Upload the new one

**This takes 10 seconds. Skip it and you lose context.**

---

## File System Explained

### 🔒 Never Update These

**`PROJECT-INSTRUCTIONS.md`**: Agent behavior instructions (lives in Project Instructions, not Knowledge)

**`core-system.md`**: LifeQuest AI methodology and philosophy

These files are **permanent**. Don't touch them.

---

### 🔄 Update These Sometimes

**`user-profile.md`**: Your character sheet with stats and background

**When to update**: When your character stats change significantly or you level up (Agent Infinity will tell you)

**`quest-log.md`**: Your active and completed quests

**When to update**: When you complete quests, start new quests, or shift priorities (Agent Infinity will help)

**`pivotal-moments.md`**: Breakthrough moments and transformations

**When to update**: When something genuinely pivotal happens - a major insight, decision, or turning point (rare)

---

### ⚡ Update EVERY SESSION

**`session-state.md`**: Your "save game" file

**This is THE MOST IMPORTANT FILE for continuity.**

**When to update**: After EVERY single session (no exceptions)

**How it works**:
1. At session end, Agent Infinity generates updated `session-state.md` as downloadable artifact
2. You download it (~3 seconds)
3. You delete old version from Project Knowledge (~3 seconds)
4. You upload new version (~4 seconds)
5. **Total time: 10 seconds**

**Why this matters**: This file contains:
- What happened last session
- Key decisions and insights
- Current emotional/mental state
- Immediate next steps
- Coaching approach preferences
- Red flags to watch

Without it, Agent Infinity starts fresh every conversation. With it, Agent Infinity picks up exactly where you left off.

---

## The Session Cycle

Here's what a typical session looks like:

### 1️⃣ Session Start

You say:
> "Hey Dan Koe, I'm back. [Brief update on what's happened since last time]"

Agent Infinity:
- Reads all your knowledge files (especially `session-state.md`)
- Acknowledges your progress
- Checks your emotional state
- Reviews active quests
- Asks what you need today

### 2️⃣ Session Work

Agent Infinity helps you with:
- Strategic decisions
- Quest planning and breakdown
- Obstacle navigation
- Mindset shifts
- Progress celebration
- New quest design

### 3️⃣ Session Close

Agent Infinity:
- Summarizes key insights
- Confirms next priority quests
- **Generates updated `session-state.md` as downloadable artifact**
- Reminds you to download/upload it

### 4️⃣ You Download & Upload

- Download the new `session-state.md` (click download button on artifact)
- Go to Project Knowledge
- Delete old `session-state.md`
- Upload new `session-state.md`
- Done! (~10 seconds)

**Next session, Agent Infinity remembers everything.**

---

## Tips for Success

### ✅ DO:
- Download and upload `session-state.md` after EVERY session
- Be honest with Agent Infinity about what you actually want (not what you "should" want)
- Use the quest log to track meaningful progress
- Document pivotal moments when they happen
- Ask for help when stuck

### ❌ DON'T:
- Skip the download/upload step (you'll lose continuity)
- Forget which version of `session-state.md` is current (download dates help)
- Try to "game" the system with fake wins (Agent Infinity sees through it)
- Update files that shouldn't be updated (core-system.md, PROJECT-INSTRUCTIONS.md)

---

## Troubleshooting

**"Agent Infinity doesn't remember our last conversation"**
- Did you upload the updated `session-state.md`?
- Check Project Knowledge - is the latest version there?
- File modified date should match your last session

**"The conversation feels generic or off"**
- Update your `user-profile.md` with more specific details
- Make sure `session-state.md` includes your coaching preferences
- Tell Agent Infinity directly what kind of support you need

**"I'm overwhelmed by the file system"**
- Start simple: Just focus on `session-state.md` (the critical one)
- Other files can be updated less frequently
- Ask Agent Infinity to help you maintain the system

**"Can I use this on mobile?"**
- Yes! Claude.ai works on mobile browsers
- Download/upload works on mobile
- Consider keeping files in mobile-accessible cloud storage

**"What if I miss updating `session-state.md`?"**
- Update it as soon as you remember
- Tell Agent Infinity "I forgot to upload the latest session state from [date]"
- Agent Infinity can help reconstruct recent context

---

## Advanced: Customizing Your System

### Adding Custom Stats

Edit `user-profile.md` to track stats that matter to you:
- Fitness level
- Language fluency
- Creative output
- Relationship quality
- Whatever matters to your journey

### Creating Custom Quest Types

Add quest categories to `quest-log.md`:
- Health quests
- Creative quests
- Relationship quests
- Learning quests
- Financial quests

### Tracking Metrics

Use the Weekly Scorecard in `quest-log.md` to track:
- Quantitative metrics (revenue, hours, posts, etc.)
- Qualitative assessments (energy level, clarity, momentum)
- Progress toward milestones

---

## Philosophy Behind the System

**Why manual state management?**

Because Claude.ai web doesn't have persistent storage. The trade-off:
- ❌ You manually download/upload files (~10 seconds per session)
- ✅ You get unlimited conversation continuity
- ✅ You own your data completely
- ✅ You can use it across devices
- ✅ No API costs, no coding required

**Why game mechanics?**

Because traditional goal-setting is boring and abstract. Game mechanics:
- Make progress tangible (levels, quests, stats)
- Provide clear feedback (you know where you stand)
- Balance challenge and skill (flow state)
- Create narrative meaning (you're the protagonist)
- Make hard things feel like play

**Why Dan Koe coaching style?**

Because:
- Honest feedback > fake positivity
- Strategic thinking > reactive advice
- Empowerment > coddling
- Evidence-based > motivational fluff
- You need a coach who won't let you play small

---

## What Makes This Different

**vs. Regular Claude conversations**:
- ✅ Remembers your full journey (not just current conversation)
- ✅ Maintains consistent coaching approach
- ✅ Tracks progress over weeks/months
- ✅ Evolves with you as you grow

**vs. Note-taking apps**:
- ✅ Interactive coaching (not passive recording)
- ✅ Strategic guidance (not just storage)
- ✅ Adaptive responses (not static templates)
- ✅ Accountability and challenge

**vs. Human life coaches**:
- ✅ Available 24/7 (not just scheduled sessions)
- ✅ Perfect memory (remembers everything)
- ✅ No judgment (radical honesty safe)
- ✅ Free after Claude Pro subscription

---

## Credits & License

**Created by**: Prisca Onyebuchi ([@prisca.franglais](https://instagram.com/prisca.franglais))

**Based on**: LifeQuest AI system by Dan Koe (adapted for manual persistence)

**License**: Free to use personally. If you share or modify, credit the source.

**Website**: [priscaonyebuchi.com](https://priscaonyebuchi.com)

---

## Ready to Begin?

You have everything you need:

1. ✅ Claude.ai Project created
2. ✅ PROJECT-INSTRUCTIONS.md in Project Instructions
3. ✅ Template files uploaded to Project Knowledge
4. ✅ Understanding of download/upload workflow

**Start your first session**:

> "Hi Dan Koe! This is my first session. I'm ready to start my LifeQuest AI journey."

And remember: Download and upload `session-state.md` after every session. That's your save button.

**Welcome to Agent Infinity. Your life is now a game you can win.**

---

*Questions, issues, or success stories? Find more resources at [priscaonyebuchi.com/case-studies/lifequest-ai-agent](https://priscaonyebuchi.com/case-studies/lifequest-ai-agent)*
